<?php
session_start();
require 'db.php';

$email = $_SESSION['reset_email'] ?? null;
if (!$email) {
    echo "<!DOCTYPE html>
        <html lang='en'>
        <head>
            <meta charset='UTF-8'>
            <meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no'>
            <title>Notice</title>
            <style>
                body { margin: 0; background-color: #d1d1d1; color: #fff; display: flex; justify-content: center; align-items: center; height: 100vh; font-family: Arial, sans-serif; text-align: center; }
                .message-box { background-color: #222; padding: 20px 30px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3); }
                .message-box h1 { color: #e91e63; font-size: 24px; margin-bottom: 15px; }
                .message-box p { font-size: 16px; margin-bottom: 20px; }
                .redirect-button { background-color: blue; color: white; border: none; padding: 10px 20px; font-size: 16px; border-radius: 4px; cursor: pointer; transition: background-color 0.3s ease; }
                .redirect-button:hover { background-color: green; }
            </style>
        </head>
        <body>
            <div class='message-box'>
                <h1>Notice</h1>
                <p>Error Processing Please Try Resending again..</p>
                <button class='redirect-button' onclick=\"window.location.href='reset_request.php';\">Resend</button>
            </div>
        </body>
        </html>";
    exit;
}

$code = $_POST['code'];
$new_password = password_hash($_POST['new_password'], PASSWORD_BCRYPT);

// Get the most recent OTP for this email
$stmt = $conn->prepare("SELECT * FROM password_resets WHERE email = ? ORDER BY expires_at DESC LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

if (!$data) {
    die("No OTP found. Please request a new one.");
    echo "<!DOCTYPE html>
        <html lang='en'>
        <head>
            <meta charset='UTF-8'>
            <meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no'>
            <title>Notice</title>
            <style>
                body { margin: 0; background-color: #d1d1d1; color: #fff; display: flex; justify-content: center; align-items: center; height: 100vh; font-family: Arial, sans-serif; text-align: center; }
                .message-box { background-color: #222; padding: 20px 30px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3); }
                .message-box h1 { color: #e91e63; font-size: 24px; margin-bottom: 15px; }
                .message-box p { font-size: 16px; margin-bottom: 20px; }
                .redirect-button { background-color: blue; color: white; border: none; padding: 10px 20px; font-size: 16px; border-radius: 4px; cursor: pointer; transition: background-color 0.3s ease; }
                .redirect-button:hover { background-color: green; }
            </style>
        </head>
        <body>
            <div class='message-box'>
                <h1>Notice</h1>
                <p>The OTP Yo provided is Incorrect . Please Try again.</p>
                <button class='redirect-button' onclick=\"window.location.href='reset_request.php';\">Resend</button>
            </div>
        </body>
        </html>";
    exit;
}

// Check if code matches
if ($data['code'] !== $code) {
    ?>
    <!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Password Updated</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f9;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      padding: 20px;
    }

    .message-box {
      max-width: 600px;
      width: 100%;
      margin: 0 auto;
      padding: 25px 20px;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
      background-color: #fff;
      text-align: center;
      border-left: 5px solid #0d6efd;
      transition: all 0.3s ease;
    }

    .message-box.success {
      border-color: #28a745;
      color: #155724;
    }

    .message-box.error {
      border-color: #dc3545;
      color: #721c24;
    }

    .message-box h2 {
      margin-bottom: 12px;
      font-size: 24px;
    }

    .message-box p {
      font-size: 18px;
      margin-bottom: 10px;
    }

    .message-box img {
      max-width: 80px;
      margin-bottom: 20px;
    }

    .message-box a {
      display: inline-block;
      margin-top: 10px;
      padding: 10px 20px;
      background-color: #0d6efd;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      transition: background 0.3s ease;
    }

    .message-box a:hover {
      background-color: #004bb5;
    }

    @media (max-width: 576px) {
      .message-box {
        padding: 20px 15px;
      }

      .message-box h2 {
        font-size: 20px;
      }

      .message-box p {
        font-size: 16px;
      }

      .message-box a {
        font-size: 15px;
        padding: 8px 16px;
      }
    }
  </style>
</head>
<body>
  <div class="message-box error">
    <img src="logo.png" alt="KYBDATA Logo">
    <h2>Password Reset Error Processing</h2>
    <p>Invalid OTP Entered.</p>
    <p>Please Resend Another One.</p>
    <p>KYBDATA APP is always there for you!</p>
    <a href="reset_request.php">← Resend</a>
  </div>
</body>
</html>
<?php
exit;

}

// Check if expired
if (strtotime($data['expires_at']) < time()) {
    echo "<!DOCTYPE html>
        <html lang='en'>
        <head>
            <meta charset='UTF-8'>
            <meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no'>
            <title>Notice</title>
            <style>
                body { margin: 0; background-color: #d1d1d1; color: #fff; display: flex; justify-content: center; align-items: center; height: 100vh; font-family: Arial, sans-serif; text-align: center; }
                .message-box { background-color: #222; padding: 20px 30px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3); }
                .message-box h1 { color: #e91e63; font-size: 24px; margin-bottom: 15px; }
                .message-box p { font-size: 16px; margin-bottom: 20px; }
                .redirect-button { background-color: blue; color: white; border: none; padding: 10px 20px; font-size: 16px; border-radius: 4px; cursor: pointer; transition: background-color 0.3s ease; }
                .redirect-button:hover { background-color: green; }
            </style>
        </head>
        <body>
            <div class='message-box'>
                <h1>Notice</h1>
                <p>The OTP Time is Expired. Please Try again.</p>
                <button class='redirect-button' onclick=\"window.location.href='reset_request.php';\">Resend</button>
            </div>
        </body>
        </html>";
    exit;
}

// Update password
$stmt = $conn->prepare("UPDATE users SET password = ? WHERE email = ?");
$stmt->bind_param("ss", $new_password, $email);
$stmt->execute();

// Cleanup
$stmt = $conn->prepare("DELETE FROM password_resets WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();

session_destroy();

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Password Updated</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f9;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      padding: 20px;
    }

    .message-box {
      max-width: 600px;
      width: 100%;
      margin: 0 auto;
      padding: 25px 20px;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
      background-color: #fff;
      text-align: center;
      border-left: 5px solid #0d6efd;
      transition: all 0.3s ease;
    }

    .message-box.success {
      border-color: #28a745;
      color: #155724;
    }

    .message-box.error {
      border-color: #dc3545;
      color: #721c24;
    }

    .message-box h2 {
      margin-bottom: 12px;
      font-size: 24px;
    }

    .message-box p {
      font-size: 18px;
      margin-bottom: 10px;
    }

    .message-box img {
      max-width: 80px;
      margin-bottom: 20px;
    }

    .message-box a {
      display: inline-block;
      margin-top: 10px;
      padding: 10px 20px;
      background-color: #0d6efd;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      transition: background 0.3s ease;
    }

    .message-box a:hover {
      background-color: #004bb5;
    }

    @media (max-width: 576px) {
      .message-box {
        padding: 20px 15px;
      }

      .message-box h2 {
        font-size: 20px;
      }

      .message-box p {
        font-size: 16px;
      }

      .message-box a {
        font-size: 15px;
        padding: 8px 16px;
      }
    }
  </style>
</head>
<body>
  <div class="message-box success">
    <img src="logo.png" alt="KYBDATA Logo">
    <h2>Password Reset Successful</h2>
    <p>Your password has been successfully updated.</p>
    <p>You can now login using your new password.</p>
    <p>KYBDATA is always there for you!</p>
    <a href="login.php">→ Go to Login</a>
  </div>
</body>
</html>