<?php include '../core/config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms of Service - <?php echo APP_NAME; ?></title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; line-height: 1.6; color: #333; max-width: 800px; margin: 0 auto; padding: 20px; }
        h1 { color: #0F2027; border-bottom: 2px solid #0F2027; padding-bottom: 10px; }
        h2 { color: #203A43; margin-top: 30px; }
    </style>
</head>
<body>

    <h1>Terms of Service</h1>
    <p><strong>Last Updated:</strong> <?php echo date("F d, Y"); ?></p>

    <p>Welcome to <strong><?php echo APP_NAME; ?></strong>. By creating an account or using our services, you agree to be bound by these Terms. If you do not agree, please do not use our services.</p>

    <h2>1. Account Responsibilities</h2>
    <p>You are responsible for maintaining the confidentiality of your account credentials (password and transaction PIN). You agree to notify us immediately of any unauthorized use of your account.</p>

    <h2>2. Services & Payments</h2>
    <ul>
        <li>All services (Data, Airtime, Bills) are subject to availability from network providers.</li>
        <li>You agree that all transactions performed with your PIN are final and authorized by you.</li>
        <li>We reserve the right to change prices at any time based on telecom provider rates.</li>
    </ul>

    <h2>3. Refund Policy</h2>
    <p>Refunds are processed only for failed transactions where value was not delivered but the wallet was charged. Funds will be reversed to your <?php echo APP_NAME; ?> wallet within 24 hours of a confirmed failure.</p>

    <h2>4. Prohibited Use</h2>
    <p>You may not use our platform for any fraudulent activity, money laundering, or illegal transactions. We reserve the right to suspend any account suspected of such activities.</p>

    <h2>5. Limitation of Liability</h2>
    <p><strong>Wisehive Sphere Ltd.</strong> shall not be liable for any indirect, incidental, or consequential damages arising from the use of our service or inability to access the service due to network failures.</p>

    <h2>6. Contact</h2>
    <p>For support or disputes, contact us at <strong><?php echo SUPPORT_EMAIL; ?></strong>.</p>

</body>
</html>