<?php
// reset_request.php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reset Password</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
      box-sizing: border-box;
      padding: 0;
      margin: 0;
    }

    html, body {
      height: 100%;
      width: 100%;
    }

    body {
      background-color: #d1d1d1;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
      font-family: Arial, sans-serif;
      text-align: center;
      padding: 20px; /* Prevent WebView edge clipping */
    }

    .form-wrapper {
      background-color: #fff;
      padding: 30px 25px;
      border-radius: 10px;
      width: 100%;
      max-width: 420px;
      box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
    }

    .form-wrapper h2 {
      text-align: center;
      margin-bottom: 25px;
      color: #333;
    }

    form {
      display: flex;
      flex-direction: column;
    }

    input[type="email"] {
      padding: 12px 15px;
      border: 1px solid #ccc;
      border-radius: 6px;
      margin-bottom: 20px;
      font-size: 16px;
      transition: border-color 0.3s;
    }

    input[type="email"]:focus {
      border-color: #007bff;
      outline: none;
    }

    button {
      padding: 12px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-size: 16px;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }

    button:hover {
      background-color: #0056b3;
    }

    @media (max-height: 500px) {
      body {
        align-items: flex-start;
        padding-top: 40px;
      }
    }

    @media (max-width: 480px) {
      .form-wrapper {
        padding: 20px;
      }

      input, button {
        font-size: 15px;
      }

      .logo img {
        height: 70px;
        width: 200px;
      }
    }

    .logo {
      text-align: center;
      margin-bottom: 20px;
    }

    .logo img {
      max-width: 100%;
      height: 90px;
      width: 250px;
      object-fit: contain;
    }

    .btn1 {
      background-color: blue;
      color: white;
      border: none;
      padding: 10px 20px;
      font-size: 16px;
      border-radius: 4px;
      cursor: pointer;
    }
  </style>
</head>
<body>
  <div class="form-wrapper">
    <div class="logo">
      <img src="logo.png" alt="KYBDATA Logo">
    </div>
    <h2>Reset Password</h2>
    <form method="POST" action="send_reset_code.php">
      <input type="email" name="email" required placeholder="Enter your registered email">
      <button type="submit" class="btn1">Send OTP</button>
    </form>
  </div>
</body>
</html>
