<?php
// receipt.php - Shows transaction status
session_start();
include 'security.php';
include 'db.php';

if (!isset($_SESSION['user_id']) || !isset($_GET['ref'])) {
    header("Location: dashboard.php");
    exit();
}

$ref = $_GET['ref'];
$stmt = $conn->prepare("SELECT * FROM transactions WHERE trans_ref = ? AND user_id = ?");
$stmt->bind_param("si", $ref, $_SESSION['user_id']);
$stmt->execute();
$trans = $stmt->get_result()->fetch_assoc();

if (!$trans) { die("Transaction not found."); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Receipt</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #f0fdf4; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .card { background: white; padding: 40px; border-radius: 20px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); text-align: center; max-width: 400px; width: 90%; }
        .icon-box { width: 80px; height: 80px; margin: 0 auto 20px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 2.5rem; }
        .success { background: #dcfce7; color: #16a34a; }
        .failed { background: #fee2e2; color: #dc2626; }
        h2 { margin: 10px 0; color: #1e293b; }
        p { color: #64748b; margin-bottom: 30px; }
        .details { text-align: left; background: #f8fafc; padding: 15px; border-radius: 10px; margin-bottom: 25px; }
        .row { display: flex; justify-content: space-between; margin-bottom: 10px; font-size: 0.9rem; }
        .btn { display: block; width: 100%; padding: 15px; background: #10b981; color: white; text-decoration: none; border-radius: 10px; font-weight: bold; }
        .btn:hover { background: #059669; }
    </style>
</head>
<body>
    <div class="card">
        <?php if ($trans['status'] == 'success'): ?>
            <div class="icon-box success"><i class="fas fa-check"></i></div>
            <h2>Transaction Successful</h2>
            <p>Your transaction has been processed.</p>
        <?php else: ?>
            <div class="icon-box failed"><i class="fas fa-times"></i></div>
            <h2>Transaction Failed</h2>
            <p>We could not process your request.</p>
        <?php endif; ?>

        <div class="details">
            <div class="row"><span>Service:</span> <strong><?php echo strtoupper($trans['transaction_type']); ?></strong></div>
            <div class="row"><span>Amount:</span> <strong>₦<?php echo number_format($trans['amount'], 2); ?></strong></div>
            <div class="row"><span>Date:</span> <span><?php echo $trans['created_at']; ?></span></div>
            <div class="row"><span>Ref:</span> <span style="font-size:0.8rem"><?php echo $trans['trans_ref']; ?></span></div>
        </div>

        <a href="dashboard.php" class="btn">Back to Dashboard</a>
    </div>
</body>
</html>