<?php
// debug_wallet.php
require 'db.php';

$user_id = 1; // CHANGE THIS to the ID of the user you are trying to fund

echo "<h2>Wallet Debugger</h2>";

// 1. Check User
$u = $conn->query("SELECT * FROM users WHERE id = $user_id");
if ($u->num_rows > 0) {
    $user = $u->fetch_assoc();
    echo "<p style='color:green'>User Found: <b>" . $user['username'] . "</b> (ID: $user_id)</p>";
} else {
    die("<p style='color:red'>User ID $user_id NOT FOUND in database.</p>");
}

// 2. Check Wallet
$w = $conn->query("SELECT * FROM wallets WHERE user_id = $user_id");
if ($w->num_rows > 0) {
    $wallet = $w->fetch_assoc();
    echo "<p style='color:green'>Wallet Found! Current Balance: <b>₦" . number_format($wallet['balance'], 2) . "</b></p>";
} else {
    echo "<p style='color:red'>CRITICAL: Wallet Row Missing for User ID $user_id</p>";
    
    // Attempt Auto-Fix
    if($conn->query("INSERT INTO wallets (user_id, balance) VALUES ($user_id, 0.00)")) {
        echo "<p style='color:blue'>Auto-Fix: Wallet created successfully. Refresh this page.</p>";
    } else {
        echo "<p style='color:red'>Auto-Fix Failed: " . $conn->error . "</p>";
    }
}
?>