<?php
session_start();
require_once '../db.php'; 

// 1. SEARCH & PAGINATION LOGIC
$search = $_GET['search'] ?? '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 50; // Show 50 per page to prevent crashing
$offset = ($page - 1) * $limit;

// Build Query
$sql = "SELECT t.*, u.username FROM transactions t LEFT JOIN users u ON t.user_id = u.id";
if ($search) {
    $sql .= " WHERE t.reference LIKE '%$search%' OR u.username LIKE '%$search%'";
}
$sql .= " ORDER BY t.created_at DESC LIMIT $limit OFFSET $offset";

$txns = $conn->query($sql);

// Get Total for Pagination buttons
$total_q = $conn->query("SELECT COUNT(id) FROM transactions");
$total_rows = $total_q->fetch_row()[0];
$total_pages = ceil($total_rows / $limit);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Transactions - Nagarta Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* --- PREMIUM THEME --- */
        :root { 
            --primary: #2c5364; --secondary: #203a43; --accent: #00d2ff; --bg: #f4f7f6; 
            --text: #334155; --white: #ffffff; --sidebar-width: 260px;
        }
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Poppins', sans-serif; -webkit-tap-highlight-color: transparent; }
        body { background:var(--bg); color:var(--text); display:flex; min-height:100vh; overflow-x: hidden; }
        
        .sidebar { width: var(--sidebar-width); background: linear-gradient(180deg, var(--secondary) 0%, var(--primary) 100%); color:white; display:flex; flex-direction:column; position: fixed; height: 100%; z-index: 1000; transition: 0.3s; left: 0; box-shadow: 5px 0 15px rgba(0,0,0,0.1); }
        .brand { padding:25px; border-bottom:1px solid rgba(255,255,255,0.05); text-align:center; }
        .brand img { max-height: 45px; }
        .nav { flex:1; padding:20px; overflow-y:auto; }
        .nav a { display:flex; align-items:center; color:rgba(255,255,255,0.7); padding:12px 15px; text-decoration:none; margin-bottom:5px; border-radius:12px; font-weight: 500; transition:0.2s; }
        .nav a:hover, .nav a.active { background:var(--white); color:var(--primary); font-weight: 600; }
        .nav i { width:30px; text-align:center; }

        .main { flex:1; margin-left: var(--sidebar-width); padding: 25px; width: calc(100% - var(--sidebar-width)); transition: 0.3s; }
        .header { display:flex; justify-content:space-between; align-items:center; margin-bottom:25px; background: var(--white); padding: 15px 20px; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.03); position: sticky; top: 0; z-index: 90; }
        .menu-toggle { display:none; font-size:1.4rem; cursor:pointer; color: var(--primary); }

        /* SEARCH BAR */
        .search-box { display:flex; gap:10px; background:#f1f5f9; padding:5px 10px; border-radius:10px; border:1px solid #e2e8f0; width:100%; max-width:400px; }
        .search-box input { border:none; background:transparent; outline:none; flex:1; font-size:0.9rem; }
        .search-box button { background:var(--primary); color:white; border:none; padding:8px 15px; border-radius:8px; cursor:pointer; }

        /* TABLE */
        .table-container { background:var(--white); border-radius:16px; padding:20px; margin-bottom:30px; box-shadow:0 10px 30px rgba(0,0,0,0.04); overflow-x: auto; }
        table { width:100%; border-collapse:collapse; min-width: 800px; }
        th, td { padding:15px; text-align:left; border-bottom:1px solid #f1f5f9; font-size:0.85rem; }
        th { background:#f8fafc; color:#64748b; font-weight:600; text-transform:uppercase; font-size:0.8rem; }
        .ref { font-family: monospace; background: #f1f5f9; padding: 4px 8px; border-radius: 5px; color: var(--primary); }
        .amt { font-weight: 700; color: var(--text); }
        
        .badge { padding:5px 12px; border-radius:20px; font-size:0.75rem; font-weight:600; }
        .badge-success { background:#dcfce7; color:#166534; }
        .badge-pending { background:#fef3c7; color:#b45309; }
        .badge-failed { background:#fee2e2; color:#991b1b; }

        /* PAGINATION */
        .pagination { display: flex; gap: 5px; justify-content: center; margin-top: 20px; }
        .page-link { padding: 8px 12px; border: 1px solid #e2e8f0; border-radius: 8px; text-decoration: none; color: var(--text); font-size: 0.9rem; background: white; }
        .page-link.active { background: var(--primary); color: white; border-color: var(--primary); }

        @media(max-width: 991px) { .sidebar { left: -280px; } .sidebar.active { left: 0; } .main { margin-left: 0; width: 100%; } .menu-toggle { display: block; } }
    </style>
</head>
<body>

<div class="sidebar">
    <div class="brand"><img src="../assets/images/logo.png" alt="Logo"></div>
    <div class="nav">
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="users.php"><i class="fas fa-users"></i> Manage Users</a>
        <a href="transactions.php" class="active"><i class="fas fa-chart-line"></i> Transactions</a>
        <a href="credit_user.php"><i class="fas fa-wallet"></i> Credit User</a>
        <a href="settings.php"><i class="fas fa-cog"></i> Settings</a>
        <a href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>
</div>

<div class="main">
    <div class="header">
        <div class="menu-toggle" onclick="document.querySelector('.sidebar').classList.toggle('active')"><i class="fas fa-bars"></i></div>
        <h3>Transaction History</h3>
        <form class="search-box" method="GET">
            <input type="text" name="search" placeholder="Search Reference or Username..." value="<?php echo htmlspecialchars($search); ?>">
            <button><i class="fas fa-search"></i></button>
        </form>
    </div>

    <div class="table-container">
        <table>
            <thead><tr><th>Date</th><th>User</th><th>Reference</th><th>Type</th><th>Amount</th><th>Status</th><th>Description</th></tr></thead>
            <tbody>
                <?php while($row = $txns->fetch_assoc()): ?>
                <tr>
                    <td><?php echo date('d M H:i', strtotime($row['created_at'])); ?></td>
                    <td><strong><?php echo $row['username'] ?? 'Unknown'; ?></strong></td>
                    <td><span class="ref"><?php echo $row['reference']; ?></span></td>
                    <td style="text-transform:uppercase; font-size:0.75rem;"><?php echo str_replace('_', ' ', $row['transaction_type']); ?></td>
                    <td class="amt">₦<?php echo number_format($row['amount'], 2); ?></td>
                    <td>
                        <span class="badge badge-<?php echo $row['status']=='success'?'success':($row['status']=='failed'?'failed':'pending'); ?>">
                            <?php echo ucfirst($row['status']); ?>
                        </span>
                    </td>
                    <td style="color:#64748b; font-size:0.8rem; max-width:200px;"><?php echo substr($row['description'], 0, 30); ?>...</td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <div class="pagination">
            <?php if($page > 1): ?>
                <a href="?page=<?php echo $page-1; ?>&search=<?php echo $search; ?>" class="page-link">Prev</a>
            <?php endif; ?>
            
            <a href="#" class="page-link active"><?php echo $page; ?></a>
            
            <?php if($page < $total_pages): ?>
                <a href="?page=<?php echo $page+1; ?>&search=<?php echo $search; ?>" class="page-link">Next</a>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>