<?php
// FILE: public_html/Nag/index.php
session_start();
require_once '../db.php';

// 1. CHECK FOR ADMIN SESSION (Not User Session)
// If already logged in as Admin, go to dashboard
if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit();
}

// 2. HANDLE LOGIN
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    // Search in 'admins' table first (Recommended)
    // If you don't have an 'admins' table, change this back to 'users' but ensure role check works.
    // Assuming you are using the 'users' table with role='admin' based on your previous code:
    
    $stmt = $conn->prepare("SELECT id, password, role FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        
        if (password_verify($password, $user['password'])) {
            // 3. VERIFY ROLE IS ADMIN
            if ($user['role'] === 'admin') {
                // ✅ SET ADMIN SESSION (Critical Fix)
                $_SESSION['admin_id'] = $user['id'];
                $_SESSION['admin_logged_in'] = true;
                
                // Optional: Destroy user session to prevent confusion
                // unset($_SESSION['user_id']); 
                
                header("Location: dashboard.php");
                exit();
            } else {
                $error = "Access Denied: You do not have admin privileges.";
            }
        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "Admin account not found.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Nagarta Data</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        body { background: #f4f7f6; font-family: 'Poppins', sans-serif; display: flex; align-items: center; justify-content: center; height: 100vh; margin: 0; }
        .login-box { background: white; padding: 40px; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); width: 100%; max-width: 400px; text-align: center; }
        .login-box img { max-height: 50px; margin-bottom: 20px; }
        input { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; }
        button { width: 100%; padding: 12px; background: #2c5364; color: white; border: none; border-radius: 8px; font-weight: bold; cursor: pointer; transition: 0.3s; }
        button:hover { background: #203a43; }
        .error { color: #e74c3c; font-size: 0.9rem; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="login-box">
        <img src="../assets/images/logo.png" alt="Admin">
        <h3>Admin Portal</h3>
        <?php if(isset($error)) echo "<p class='error'>$error</p>"; ?>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>